@extends('layout')
@section('content')
    @include('partials.breadcrumb')


    <!-- login begin-->
    <div class="contact login">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-6">
                    @include('errors.alert')

                    <form action="{{route('user.password.request')}}" method="post" class="contact-form">
                        @csrf


                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="row">
                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label for="InputName">@lang('E-Mail  Address')<span class="requred">*</span></label>
                                    <input type="email" name="email" placeholder="@lang('Enter E-mail Address')" value="{{$email}}"  class="form-control" required readonly>
                                    @if ($errors->has('email'))
                                        <span class="error">{{ __($errors->first('email')) }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label for="InputName">@lang('Password')<span class="requred">*</span></label>
                                    <input type="password" name="password" id="InputPassword" placeholder="@lang('Enter Password')" class="form-control" required>
                                    @if ($errors->has('password'))
                                        <span class="error">{{ __($errors->first('password')) }}</span>
                                    @endif
                                </div>
                            </div>


                            <div class="col-xl-12 col-lg-12">
                                <div class="form-group">
                                    <label>@lang('Re-type Password')<span class="requred">*</span></label>
                                    <input type="password" name="password_confirmation" class="form-control" placeholder="@lang('Re-type Password')">
                                </div>
                            </div>


                            <div class="col-xl-12 col-lg-12">
                                <button type="submit" id="custom-button">@lang('Submit')</button>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- login end -->

@endsection






